package gov.va.med.domain;

import com.fortify.annotations.FortifyNotPassword;

public interface DomainConstants {
	
	/**
	 * ConfigService DomainConstants
	 */
	public static final String APP_DEFAULT_MAX_ROWS_IN_MEMORY = "app:DEFAULT_MAX_ROWS_IN_MEMORY";
	public static final String APP_DEFAULT_PAGE_SIZE = "app:DEFAULT_PAGE_SIZE";
    public static final String DATABASE_DATASOURCE = "database:dataSource";
	public static final String DATABASE_STANDALONE = "database:standAlone";
	public static final String DATABASE_DB_URL = "database:standAloneDbUrl";
	public static final String DATABASE_DB_USERNAME = "database:standAloneDbUsername";
	
	public static final String CACHE_DEBUG = "cache:DEBUG";
	public static final String CACHE_REF_CODES_TABLE_NAME = "cache:REF_CODES_TABLE_NAME";
	public static final String CACHE_STD_COUNTRY_VWS_NAME = "cache:STD_COUNTRY_VWS_NAME";
	public static final String CACHE_STD_STATE_VWS_NAME = "cache:STD_STATE_VWS_NAME";
	public static final String CACHE_REF_CODES_REACTION_TYPE_TABLE = "cache:REF_CODES_REACTION_TYPE_TABLE";
	public static final String CACHE_REF_CODES_VACCINE_TYPE_TABLE = "cache:REF_CODES_VACCINE_TYPE_TABLE";
	public static final String CACHE_VACCINE_TYPES_DOMAIN = "cache:VACCINE_TYPES_DOMAIN";
	public static final String CACHE_REACTION_TYPES_NOTOSS_DOMAIN = "cache:REACTION_TYPES_NOTOSS_DOMAIN";
	public static final String CACHE_REACTION_TYPES_OSS_DOMAIN = "cache:REACTION_TYPES_OSS_DOMAIN";
	
	@FortifyNotPassword
	public static final String REF_CODE_PASSWORD_QUESTION_LIST = "refcode:PASSWORD_QUESTIONS";
	public static final String REF_CODE_MEAL_TYPE = "refcode:MEAL_TYPE";
    public static final String REF_CODE_MEAL_SERVING_SIZE = "refcode:MEAL_ITEM_SERVING_SIZE";
    public static final String REF_CODE_MEAL_ITEM_PREP_METHOD = "refcode:MEAL_ITEM_PREP_METHOD";
    public static final String REF_CODE_MEAL_ITEM_QUANTITY = "refcode:MEAL_ITEM_QUANTITY";
	  
	public static final String USERMGMT_SUBSEQUENT_FAILURES_FOR_TEMP_LOCKOUT = "userMgmt:login_failures_for_temp_lockout";
	public static final String USERMGMT_TEMP_LOCKOUT_PERIOD = "userMgmt:login_temp_lockout_period";
	@FortifyNotPassword
	public static final String USERMGMT_TEMPORARY_PASSWORD_EXPIRATION_DAYS = "userMgmt:temp_password_expiration_period";
	@FortifyNotPassword
	public static final String USERMGMT_PASSWORD_CHANGE_NOTIFICATION_PERIOD = "userMgmt:password_notification_period";
	@FortifyNotPassword
	public static final String USERMGMT_PASSWORD_EXPIRATION_ENABLED = "userMgmt:password_expiration_enabled";
	@FortifyNotPassword
	public static final String USERMGMT_PASSWORD_EXPIRATION_PERIOD = "userMgmt:password_expiration_period";
	@FortifyNotPassword
	public static final String USERMGMT_FORGOT_PASSWORD_LOCKOUT_LIMIT = "userMgmt:FORGOTPWD_ANSWER_FAILURE_THRESHOLD";	
	public static final String USERMGMT_TRACKING_ACTIVITY_DATE_FORMAT = "userMgmt:TRACKING_ACTIVITY_DATE_FORMAT";
	@FortifyNotPassword
	public static final String USERMGMT_TEMP_PASSWORD_IND = "userMgmt:TEMP_PASSWORD_IND";
	@FortifyNotPassword
	public static final String USERMGMT_NON_TEMP_PASSWORD_IND = "userMgmt:NON_TEMP_PASSWORD_IND";
	public static final String USERMGMT_USER_ACTIVE_STATUS = "userMgmt:USER_ACTIVE_STATUS";
	public static final String USERMGMT_USER_INACTIVE_STATUS = "userMgmt:USER_INACTIVE_STATUS";
	public static final String USERMGMT_LDAP_AUTHENTICATOR_MBEAN_NAME = "userMgmt:LDAP_AUTHENTICATOR_MBEAN_NAME";
	
	
    public static final String USERMGMT_DAYLIST_NULL = "userMgmt:DAYLIST_NULL";
    public static final String USERMGMT_FORGOTPWD_ANSWER_FAILURE_THRESHOLD = "userMgmt:FORGOTPWD_ANSWER_FAILURE_THRESHOLD";
    public static final String USERMGMT_FORGOTPWD_USERID_FAILURE_THRESHOLD = "userMgmt:FORGOTPWD_USERID_FAILURE_THRESHOLD";
    public static final String USERMGMT_FORGOTUID_IDENTITY_FAILURE_THRESHOLD = "userMgmt:FORGOTUID_IDENTITY_FAILURE_THRESHOLD";
    public static final String USERMGMT_MONTHLIST_NULL = "userMgmt:MONTHLIST_NULL"; 
    public static final String USERMGMT_YEARLIST_NULL = "userMgmt:YEARLIST_NULL";
    public static final String USERMGMT_YEARLIST_START = "userMgmt:YEARLIST_START";
  
    public static final String MAIL_HELPDESK_EMAIL = "mail:HELPDESK_EMAIL";
    public static final String MAIL_SESSION = "mail:EMAIL_SESSION";
	
	public static final String SDS_ALL_COUNTRY_NULL = "SDS:ALL_COUNTRY_NULL";
	public static final String SDS_ALL_STATE_NULL = "SDS:ALL_STATE_NULL";
	public static final String SDS_DEF_COUNTRY_ID = "SDS:DEFAULT_COUNTRY_ID";
	
	
	public static final String SEI_TRACKING_DATE_FORMAT = "SEI:TRACKING_DATE_FORMAT";
	
	public static final String SERVER_ADMIN_PORT = "server:adminServerPort";
	public static final String SERVER_ADMIN_SERVER = "server:adminServerHost";
	public static final String SERVER_ADMIN_USERID = "server:adminServerUserName";
	
	/**
	 * MPI constants
	 */
	public static final String MPI_STATION_NUMBER = "mpi:MPI_STATION_NUMBER";
	public static final String USE_FIRSTNAME_IN_PATIENT_LOOKUP_QUERY = "mpi:USE_FIRSTNAME_IN_PATIENT_LOOKUP_QUERY";
	// The policy is used to determine whether a cached ICN can be reused or whether a new request
	// has to be generated against MPI. Two policies are currently supported:
	// MPI_LOOKUP_POLICY = requests-per-day; allows the application to specify how many requests can be invoked
	//          against MPI per day. The number or requests parameter is specified via MPI_REQUESTS_PER DAY
	// MPI_LOOKUP_POLICY = request-time-window; allows the application to specify how frequently a request
	//          can be invoked against MPI. The MPI_REQUEST_TIME_WINDOW specifies the amount of time between
	//          requests in minutes.
	public static final String MPI_LOOKUP_POLICY = "mpi:MPI_LOOKUP_POLICY";
	public static final String MPI_LOOKUP_POLICY_REQUESTS_PER_DAY = "requests-per-day";
	public static final String MPI_LOOKUP_POLICY_REQUEST_TIME_WINDOW = "request-time-window";
	public static final String MPI_REQUESTS_PER_DAY = "mpi:MPI_REQUESTS_PER_DAY";
	public static final String MPI_REQUEST_TIME_WINDOW = "mpi:MPI_REQUEST_TIME_WINDOW";
    
    //MHV constants
    public static final String MHV_SYSTEM_TYPE = "mhv:MHV_SYSTEM_TYPE";
	public static final String MHV_STATION_NUMBER = "mhv:MHV_STATION_NUMBER";
    
    /**
     * Common domain constants
     */
    public static final String DOMAIN_SHORT_DATE_FORMAT="app:SHORT_DATE_FORMAT";
    public static final String DOMAIN_LONG_DATE_FORMAT="app:LONG_DATE_FORMAT";

	/*
	 * System configuration entry constants. These correspond to the NAME column of the SYSTEM_CONF table
	 * used to store generic, enterprise configurable values that can be changed on the fly without affecting
	 * system deployment or packaging.
	 */
	// pointer to the configuration entry representing the interval between when a user's prerequisites are saved and
	// when the system will automatically authenticate that user if s/he has not been completed manually by a clerk
	public static final String SYS_CFG_AUTO_AUTH_INTERVAL = "AUTO_AUTH_INTERVAL";
	
	
	/**
	 * Cache constants
	 */
	public static final String CACHE_DESTINATIONS_DOMAIN = "cache:MESSAGING_DESTINATIONS_DOMAIN";
	public static final String CACHE_DESTINATIONS_MAP_KEY = "cache:MESSAGING_DESTINATIONS_KEY";
	
	/*
	 * The following cache constants are used by VAMC portal.
	 */
	public static final String CACHE_AUTH_REMOVAL_REASON = "cache:AUTH_REMOVAL_REASON";
    public static final String CACHE_AUTH_DEFERRAL_REASON = "cache:AUTH_DEFERRAL_REASON";
    public static final String CACHE_VERIFICATION_METHOD = "cache:VERIFICATION_METHOD";
	
	public static final String Y_INDICATOR = "Y";
	public static final String N_INDICATOR = "N";
}
